import java.awt.Frame;
import java.awt.Dialog;
import java.awt.Button;
import java.awt.Event;
import java.awt.Panel;
import java.awt.Label;
import java.awt.Font;
import java.awt.TextField;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.CheckboxGroup;
import java.awt.Checkbox;


public class ComputerProperties extends Dialog {
    Button  m_ButtonOK;
    Computer m_Computer;
    Checkbox m_Protocol1;
    Checkbox m_Protocol2;
    Checkbox m_Protocol3;
    Checkbox m_Protocol4;
    TextField m_Edit1;

    public ComputerProperties(Frame frame) {
        super(frame,false);
        this.setLayout(new BorderLayout(15,15));
        // Set Title
        setTitle("Computer's Properties");
        // Selection Radiobuttons
        CheckboxGroup cbg = new CheckboxGroup();
        Panel p = new Panel();
        p.setLayout(new FlowLayout(FlowLayout.LEFT,20,15));
        p.add(new FontLabel("Computer's Protocol:","Helvetica",Font.BOLD,20,230,30));
        p.add(m_Protocol1 = new Checkbox("1 Bit Stop and Wait    ",cbg,false));
        p.add(m_Protocol2 = new Checkbox("3 Bit Go-back-n with indiv. Ack",cbg,true));
        p.add(m_Protocol3 = new Checkbox("4 Bit Go-back-n with incl. Ack",cbg,true));
        p.add(m_Protocol4 = new Checkbox("3 Bit Selective Repeat with incl. Ack",cbg,true));
        p.add(new FontLabel("Timeout:","Helvetica",Font.BOLD,20,230,30));
        p.add(m_Edit1 = new TextField(7));
        p.add(new Label("ms"));
        this.add("Center",p);
        // OK Button
        p = new Panel();
        p.setLayout(new FlowLayout(FlowLayout.CENTER,15,15));
        p.add(m_ButtonOK = new Button("Ok"));
        this.add("South",p);
    }

    public boolean action(Event e, Object arg) {
        if (e.target instanceof Button) {
            Steuerung.m_iMillisPerTimeStep = Integer.valueOf(m_Edit1.getText()).intValue()/Global.sender.protocol().m_iTimeSteps;
            this.hide();
            return(true);
        }
        if (e.target == m_Protocol1) {
            synchronized (Global.sender.protocol()) {
                Global.sender.setProtocol((new StopAndWait(Global.sender)));
            }
            synchronized (Global.receiver.protocol()) {
                Global.receiver.setProtocol((new StopAndWait(Global.receiver)));
            }
            Global.channel.clearChannel();
            ((SenderPanel)Global.sender.panel()).redisplay(Global.sender.protocol().sendWindow,
                                                           Global.sender.protocol().receiveWindow);
            ((ReceiverPanel)Global.receiver.panel()).redisplay(Global.receiver.protocol().sendWindow,
                                                           Global.receiver.protocol().receiveWindow);
       		Global.historyPanel.clear();
            return(true);
        }
        if (e.target == m_Protocol2) {
            synchronized (Global.sender.protocol()) {
                Global.sender.setProtocol((new SimpleProtocol(Global.sender)));
            }
            synchronized (Global.receiver.protocol()) {
                Global.receiver.setProtocol((new SimpleProtocol(Global.receiver)));
            }
            Global.channel.clearChannel();
            ((SenderPanel)Global.sender.panel()).redisplay(Global.sender.protocol().sendWindow,
                                                           Global.sender.protocol().receiveWindow);
            ((ReceiverPanel)Global.receiver.panel()).redisplay(Global.receiver.protocol().sendWindow,
                                                           Global.receiver.protocol().receiveWindow);
       		Global.historyPanel.clear();
            return(true);
        }
        if (e.target == m_Protocol3) {
            synchronized (Global.sender.protocol()) {
                Global.sender.setProtocol((new GoBackN2(Global.sender)));
            }
            synchronized (Global.receiver.protocol()) {
                Global.receiver.setProtocol((new GoBackN2(Global.receiver)));
            }
            Global.channel.clearChannel();
            ((SenderPanel)Global.sender.panel()).redisplay(Global.sender.protocol().sendWindow,
                                                           Global.sender.protocol().receiveWindow);
            ((ReceiverPanel)Global.receiver.panel()).redisplay(Global.receiver.protocol().sendWindow,
                                                           Global.receiver.protocol().receiveWindow);
       		Global.historyPanel.clear();
            return(true);
        }
        if (e.target == m_Protocol4) {
            synchronized (Global.sender.protocol()) {
                Global.sender.setProtocol((new SelectiveRepeat(Global.sender)));
            }
            synchronized (Global.receiver.protocol()) {
                Global.receiver.setProtocol((new SelectiveRepeat(Global.receiver)));
            }
            Global.channel.clearChannel();
            ((SenderPanel)Global.sender.panel()).redisplay(Global.sender.protocol().sendWindow,
                                                           Global.sender.protocol().receiveWindow);
            ((ReceiverPanel)Global.receiver.panel()).redisplay(Global.receiver.protocol().sendWindow,
                                                           Global.receiver.protocol().receiveWindow);
       		Global.historyPanel.clear();
            return(true);
        }
        if (e.target == m_Edit1) {
            Steuerung.m_iMillisPerTimeStep = Integer.valueOf(m_Edit1.getText()).intValue()/Global.sender.protocol().m_iTimeSteps;
            return(true);
        }

        return(false);
    }

    public void show() {
        super.show();
        if (Global.sender.protocol() instanceof SimpleProtocol) {
            m_Protocol2.setState(true);
        }
        if (Global.sender.protocol() instanceof StopAndWait) {
            m_Protocol1.setState(true);
        }
        if (Global.sender.protocol() instanceof GoBackN2) {
            m_Protocol3.setState(true);
        }
        if (Global.sender.protocol() instanceof SelectiveRepeat) {
            m_Protocol4.setState(true);
        }
        m_Edit1.setText(Integer.toString(Global.sender.protocol().m_iTimeSteps*Steuerung.m_iMillisPerTimeStep));
    }

}

